/*jslint node: true, nomen: true, unparam: true */
/*global jquery, _, $, define, navigator, window */

define(['jquery', 'backbone', 'marionette', 'underscore', 'handlebars'],
    function ($, Backbone, Marionette, _, Handlebars) {
        'use strict';
        var Portal = new Backbone.Marionette.Application();

        function isMobile() {
            var userAgent = navigator.userAgent || navigator.vendor || window.opera;
            return ((/iPhone|iPod|iPad|Android|BlackBerry|Opera Mini|IEMobile/).test(userAgent));
        }

        //Organize Application into regions corresponding to DOM elements
        //Regions can contain views, Layouts, or subregions nested as necessary
        Portal.addRegions({
            head: "head",
            containerRegion: "#portal-container",
            footerRegion: "#portal-footer",
            panelRegion: "#portal-panel"
        });

        Portal.addInitializer(function () {
            Backbone.history.start();
        });

        Portal.mobile = isMobile();

        return Portal;
    });